/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.zb;

import com.gprinter.zb.CustomGZIPInputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

class Base64 {
    public static final int NO_OPTIONS = 0;
    public static final int ENCODE = 1;
    public static final int DECODE = 0;
    public static final int GZIP = 2;
    public static final int DONT_BREAK_LINES = 8;
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final String PREFERRED_ENCODING = "UTF-8";
    private static final byte[] ALPHABET;
    private static final byte[] _NATIVE_ALPHABET;
    private static final byte[] DECODABET;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    private Base64() {
    }

    private static byte[] encode3to4(byte[] var0, byte[] var1, int var2) {
        Base64.encode3to4(var1, 0, var2, var0, 0);
        return var0;
    }

    private static byte[] encode3to4(byte[] var0, int var1, int var2, byte[] var3, int var4) {
        int var5 = (var2 > 0 ? var0[var1] << 24 >>> 8 : 0) | (var2 > 1 ? var0[var1 + 1] << 24 >>> 16 : 0) | (var2 > 2 ? var0[var1 + 2] << 24 >>> 24 : 0);
        switch (var2) {
            case 1: {
                var3[var4] = ALPHABET[var5 >>> 18];
                var3[var4 + 1] = ALPHABET[var5 >>> 12 & 0x3F];
                var3[var4 + 2] = 61;
                var3[var4 + 3] = 61;
                return var3;
            }
            case 2: {
                var3[var4] = ALPHABET[var5 >>> 18];
                var3[var4 + 1] = ALPHABET[var5 >>> 12 & 0x3F];
                var3[var4 + 2] = ALPHABET[var5 >>> 6 & 0x3F];
                var3[var4 + 3] = 61;
                return var3;
            }
            case 3: {
                var3[var4] = ALPHABET[var5 >>> 18];
                var3[var4 + 1] = ALPHABET[var5 >>> 12 & 0x3F];
                var3[var4 + 2] = ALPHABET[var5 >>> 6 & 0x3F];
                var3[var4 + 3] = ALPHABET[var5 & 0x3F];
                return var3;
            }
        }
        return var3;
    }

    public static String encodeObject(Serializable var0) {
        return Base64.encodeObject(var0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeObject(Serializable var0, int var1) {
        ByteArrayOutputStream var2;
        block33: {
            Object var9;
            var2 = null;
            OutputStream var3 = null;
            ObjectOutputStream var4 = null;
            DeflaterOutputStream var5 = null;
            int var6 = var1 & 2;
            int var7 = var1 & 8;
            try {
                var2 = new ByteArrayOutputStream();
                var3 = new OutputStream(var2, 1 | var7);
                if (var6 == 2) {
                    var5 = new GZIPOutputStream(var3);
                    var4 = new ObjectOutputStream(var5);
                } else {
                    var4 = new ObjectOutputStream(var3);
                }
                var4.writeObject(var0);
                break block33;
            }
            catch (IOException var33) {
                var33.printStackTrace();
                var9 = null;
            }
            finally {
                try {
                    var4.close();
                }
                catch (Exception exception) {}
                try {
                    var5.close();
                }
                catch (Exception exception) {}
                try {
                    var3.close();
                }
                catch (Exception exception) {}
                try {
                    var2.close();
                }
                catch (Exception exception) {}
            }
            return var9;
        }
        try {
            return new String(var2.toByteArray(), PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException var32) {
            return new String(var2.toByteArray());
        }
    }

    public static String encodeBytes(byte[] var0) {
        return Base64.encodeBytes(var0, 0, var0.length, 0);
    }

    public static String encodeBytes(byte[] var0, int var1) {
        return Base64.encodeBytes(var0, 0, var0.length, var1);
    }

    public static String encodeBytes(byte[] var0, int var1, int var2) {
        return Base64.encodeBytes(var0, var1, var2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeBytes(byte[] var0, int var1, int var2, int var3) {
        int var4 = var3 & 8;
        int var5 = var3 & 2;
        if (var5 == 2) {
            ByteArrayOutputStream var34;
            block31: {
                Object var37;
                var34 = null;
                DeflaterOutputStream var35 = null;
                OutputStream var36 = null;
                try {
                    var34 = new ByteArrayOutputStream();
                    var36 = new OutputStream(var34, 1 | var4);
                    var35 = new GZIPOutputStream(var36);
                    ((GZIPOutputStream)var35).write(var0, var1, var2);
                    var35.close();
                    break block31;
                }
                catch (IOException var32) {
                    var32.printStackTrace();
                    var37 = null;
                }
                finally {
                    try {
                        var35.close();
                    }
                    catch (Exception var32) {}
                    try {
                        var36.close();
                    }
                    catch (Exception var32) {}
                    try {
                        var34.close();
                    }
                    catch (Exception var32) {}
                }
                return var37;
            }
            try {
                return new String(var34.toByteArray(), PREFERRED_ENCODING);
            }
            catch (UnsupportedEncodingException var30) {
                return new String(var34.toByteArray());
            }
        }
        boolean var6 = var4 == 0;
        int var7 = var2 * 4 / 3;
        byte[] var8 = new byte[var7 + (var2 % 3 > 0 ? 4 : 0) + (var6 ? var7 / 76 : 0)];
        int var9 = 0;
        int var10 = 0;
        int var11 = var2 - 2;
        int var12 = 0;
        while (var9 < var11) {
            Base64.encode3to4(var0, var9 + var1, 3, var8, var10);
            if (var6 && (var12 += 4) == 76) {
                var8[var10 + 4] = 10;
                ++var10;
                var12 = 0;
            }
            var9 += 3;
            var10 += 4;
        }
        if (var9 < var2) {
            Base64.encode3to4(var0, var9 + var1, var2 - var9, var8, var10);
            var10 += 4;
        }
        try {
            return new String(var8, 0, var10, PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException var31) {
            return new String(var8, 0, var10);
        }
    }

    private static int decode4to3(byte[] var0, int var1, byte[] var2, int var3) {
        if (var0[var1 + 2] == 61) {
            int var4 = (DECODABET[var0[var1]] & 0xFF) << 18 | (DECODABET[var0[var1 + 1]] & 0xFF) << 12;
            var2[var3] = (byte)(var4 >>> 16);
            return 1;
        }
        if (var0[var1 + 3] == 61) {
            int var4 = (DECODABET[var0[var1]] & 0xFF) << 18 | (DECODABET[var0[var1 + 1]] & 0xFF) << 12 | (DECODABET[var0[var1 + 2]] & 0xFF) << 6;
            var2[var3] = (byte)(var4 >>> 16);
            var2[var3 + 1] = (byte)(var4 >>> 8);
            return 2;
        }
        try {
            int var4 = (DECODABET[var0[var1]] & 0xFF) << 18 | (DECODABET[var0[var1 + 1]] & 0xFF) << 12 | (DECODABET[var0[var1 + 2]] & 0xFF) << 6 | DECODABET[var0[var1 + 3]] & 0xFF;
            var2[var3] = (byte)(var4 >> 16);
            var2[var3 + 1] = (byte)(var4 >> 8);
            var2[var3 + 2] = (byte)var4;
            return 3;
        }
        catch (Exception var5) {
            return -1;
        }
    }

    public static byte[] decode(byte[] var0, int var1, int var2) {
        int var3 = var2 * 3 / 4;
        byte[] var4 = new byte[var3];
        int var5 = 0;
        byte[] var6 = new byte[4];
        int var7 = 0;
        boolean var8 = false;
        boolean var9 = false;
        boolean var10 = false;
        for (int var12 = var1; var12 < var1 + var2; ++var12) {
            byte var13 = (byte)(var0[var12] & 0x7F);
            byte var14 = DECODABET[var13];
            if (var14 < -5) {
                return null;
            }
            if (var14 < -1) continue;
            var6[var7++] = var13;
            if (var7 <= 3) continue;
            var5 += Base64.decode4to3(var6, 0, var4, var5);
            var7 = 0;
            if (var13 == 61) break;
        }
        byte[] var11 = new byte[var5];
        System.arraycopy(var4, 0, var11, 0, var5);
        return var11;
    }

    public static byte[] decode(String var0) {
        return Base64.decode(var0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decode(String var0, boolean var1) {
        int var3;
        byte[] var2;
        try {
            var2 = var0.getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException var27) {
            var2 = var0.getBytes();
        }
        var2 = Base64.decode(var2, 0, var2.length);
        if (var2 != null && var2.length >= 4 && (35615 == (var3 = var2[0] & 0xFF | var2[1] << 8 & 0xFF00) || var1)) {
            ByteArrayInputStream var4 = null;
            CustomGZIPInputStream var5 = null;
            ByteArrayOutputStream var6 = null;
            byte[] var7 = new byte[512];
            boolean var8 = false;
            try {
                int var30;
                var6 = new ByteArrayOutputStream();
                var4 = new ByteArrayInputStream(var2);
                var5 = new CustomGZIPInputStream(var4);
                while ((var30 = var5.read(var7)) >= 0) {
                    var6.write(var7, 0, var30);
                }
                var2 = var6.toByteArray();
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    var6.close();
                }
                catch (Exception exception) {}
                try {
                    var5.close();
                }
                catch (Exception exception) {}
                try {
                    var4.close();
                }
                catch (Exception exception) {}
            }
        }
        return var2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object decodeToObject(String var0) {
        byte[] var1 = Base64.decode(var0);
        ByteArrayInputStream var2 = null;
        ObjectInputStream var3 = null;
        Object var4 = null;
        try {
            var2 = new ByteArrayInputStream(var1);
            var3 = new ObjectInputStream(var2);
            var4 = var3.readObject();
        }
        catch (IOException var21) {
            var21.printStackTrace();
            var4 = null;
        }
        catch (ClassNotFoundException var22) {
            var22.printStackTrace();
            var4 = null;
        }
        finally {
            try {
                var2.close();
            }
            catch (Exception var21) {}
            try {
                var3.close();
            }
            catch (Exception var21) {}
        }
        return var4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean encodeToFile(byte[] var0, String var1) {
        boolean var2 = false;
        OutputStream var3 = null;
        try {
            var3 = new OutputStream(new FileOutputStream(var1), 1);
            var3.write(var0);
            var2 = true;
        }
        catch (IOException var13) {
            var2 = false;
        }
        finally {
            try {
                var3.close();
            }
            catch (Exception exception) {}
        }
        return var2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean decodeToFile(String var0, String var1) {
        boolean var2 = false;
        OutputStream var3 = null;
        try {
            var3 = new OutputStream(new FileOutputStream(var1), 0);
            var3.write(var0.getBytes(PREFERRED_ENCODING));
            var2 = true;
        }
        catch (IOException var13) {
            var2 = false;
        }
        finally {
            try {
                var3.close();
            }
            catch (Exception exception) {}
        }
        return var2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decodeFromFile(String var0) {
        byte[] var1 = null;
        FilterInputStream var2 = null;
        try {
            int var21;
            File var3 = new File(var0);
            Object var4 = null;
            int var5 = 0;
            boolean var6 = false;
            if (var3.length() > Integer.MAX_VALUE) {
                Object var7 = null;
                byte[] byArray = var7;
                return byArray;
            }
            byte[] var20 = new byte[(int)var3.length()];
            var2 = new InputStream(new BufferedInputStream(new FileInputStream(var3)), 0);
            while ((var21 = ((InputStream)var2).read(var20, var5, 4096)) >= 0) {
                var5 += var21;
            }
            var1 = new byte[var5];
            System.arraycopy(var20, 0, var1, 0, var5);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                var2.close();
            }
            catch (Exception exception) {}
        }
        return var1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeFromFile(String var0) {
        String var1 = null;
        FilterInputStream var2 = null;
        try {
            int var17;
            File var3 = new File(var0);
            byte[] var4 = new byte[(int)((double)var3.length() * 1.4)];
            int var5 = 0;
            boolean var6 = false;
            var2 = new InputStream(new BufferedInputStream(new FileInputStream(var3)), 1);
            while ((var17 = ((InputStream)var2).read(var4, var5, 4096)) >= 0) {
                var5 += var17;
            }
            var1 = new String(var4, 0, var5, PREFERRED_ENCODING);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                var2.close();
            }
            catch (Exception exception) {}
        }
        return var1;
    }

    static {
        byte[] var0;
        _NATIVE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        try {
            var0 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException var2) {
            var0 = _NATIVE_ALPHABET;
        }
        ALPHABET = var0;
        DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
    }

    public static class InputStream
    extends FilterInputStream {
        private boolean encode;
        private int position;
        private byte[] buffer;
        private int bufferLength;
        private int numSigBytes;
        private int lineLength;
        private boolean breakLines;

        public InputStream(java.io.InputStream var1) {
            this(var1, 0);
        }

        public InputStream(java.io.InputStream var1, int var2) {
            super(var1);
            this.breakLines = (var2 & 8) != 8;
            this.encode = (var2 & 1) == 1;
            this.bufferLength = this.encode ? 4 : 3;
            this.buffer = new byte[this.bufferLength];
            this.position = -1;
            this.lineLength = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.position < 0) {
                byte[] var1;
                if (!this.encode) {
                    int var2;
                    var1 = new byte[4];
                    boolean var7 = false;
                    for (var2 = 0; var2 < 4; ++var2) {
                        int var3;
                        boolean var8 = false;
                        while ((var3 = this.in.read()) >= 0 && DECODABET[var3 & 0x7F] <= -5) {
                        }
                        if (var3 < 0) break;
                        var1[var2] = (byte)var3;
                    }
                    if (var2 != 4) {
                        if (var2 == 0) {
                            return -1;
                        }
                        throw new IOException("Improperly padded Base64 input.");
                    }
                    this.numSigBytes = Base64.decode4to3(var1, 0, this.buffer, 0);
                    this.position = 0;
                } else {
                    var1 = new byte[3];
                    int var2 = 0;
                    int var3 = 0;
                    while (true) {
                        block17: {
                            if (var3 >= 3) {
                                if (var2 <= 0) {
                                    return -1;
                                }
                                Base64.encode3to4(var1, 0, var2, this.buffer, 0);
                                this.position = 0;
                                this.numSigBytes = 4;
                                break;
                            }
                            try {
                                int var4 = this.in.read();
                                if (var4 >= 0) {
                                    var1[var3] = (byte)var4;
                                    ++var2;
                                }
                            }
                            catch (IOException var5) {
                                if (var3 != 0) break block17;
                                throw var5;
                            }
                        }
                        ++var3;
                    }
                }
            }
            if (this.position >= 0) {
                if (this.position >= this.numSigBytes) {
                    return -1;
                }
                if (this.encode && this.breakLines && this.lineLength >= 76) {
                    this.lineLength = 0;
                    return 10;
                }
                ++this.lineLength;
                byte var6 = this.buffer[this.position++];
                if (this.position >= this.bufferLength) {
                    this.position = -1;
                }
                return var6 & 0xFF;
            }
            throw new IOException("Error in Base64 code reading stream.");
        }

        @Override
        public int read(byte[] var1, int var2, int var3) throws IOException {
            int var4;
            for (var4 = 0; var4 < var3; ++var4) {
                int var5 = this.read();
                if (var5 < 0) {
                    if (var4 != 0) break;
                    return -1;
                }
                var1[var2 + var4] = (byte)var5;
            }
            return var4;
        }
    }

    public static class OutputStream
    extends FilterOutputStream {
        private boolean encode;
        private int position;
        private byte[] buffer;
        private int bufferLength;
        private int lineLength;
        private boolean breakLines;
        private byte[] b4;
        private boolean suspendEncoding;

        public OutputStream(java.io.OutputStream var1) {
            this(var1, 1);
        }

        public OutputStream(java.io.OutputStream var1, int var2) {
            super(var1);
            this.breakLines = (var2 & 8) != 8;
            this.encode = (var2 & 1) == 1;
            this.bufferLength = this.encode ? 3 : 4;
            this.buffer = new byte[this.bufferLength];
            this.position = 0;
            this.lineLength = 0;
            this.suspendEncoding = false;
            this.b4 = new byte[4];
        }

        @Override
        public void write(int var1) throws IOException {
            if (this.suspendEncoding) {
                this.out.write(var1);
            } else if (this.encode) {
                this.buffer[this.position++] = (byte)var1;
                if (this.position >= this.bufferLength) {
                    this.out.write(Base64.encode3to4(this.b4, this.buffer, this.bufferLength));
                    this.lineLength += 4;
                    if (this.breakLines && this.lineLength >= 76) {
                        this.out.write(10);
                        this.lineLength = 0;
                    }
                    this.position = 0;
                }
            } else if (DECODABET[var1 & 0x7F] > -5) {
                this.buffer[this.position++] = (byte)var1;
                if (this.position >= this.bufferLength) {
                    int var2 = Base64.decode4to3(this.buffer, 0, this.b4, 0);
                    this.out.write(this.b4, 0, var2);
                    this.position = 0;
                }
            } else if (DECODABET[var1 & 0x7F] != -5) {
                throw new IOException("Invalid character in Base64 data.");
            }
        }

        @Override
        public void write(byte[] var1, int var2, int var3) throws IOException {
            if (this.suspendEncoding) {
                this.out.write(var1, var2, var3);
            } else {
                for (int var4 = 0; var4 < var3; ++var4) {
                    this.write(var1[var2 + var4]);
                }
            }
        }

        public void flushBase64() throws IOException {
            if (this.position > 0) {
                if (!this.encode) {
                    throw new IOException("Base64 input not properly padded.");
                }
                this.out.write(Base64.encode3to4(this.b4, this.buffer, this.position));
                this.position = 0;
            }
        }

        @Override
        public void close() throws IOException {
            this.flushBase64();
            super.close();
            this.buffer = null;
            this.out = null;
        }

        public void suspendEncoding() throws IOException {
            this.flushBase64();
            this.suspendEncoding = true;
        }

        public void resumeEncoding() {
            this.suspendEncoding = false;
        }
    }
}

